
' 555lcd.bas ver8.1 21-oct-2006
' by K.S. Sankar www.mostek.biz India
' for MCS Electronics, Holland
' (byte end hex=) 80  in misc settings
'-------------------------------------
$large
$regfile = "89s8252.dat"
$crystal = 6000000

Dim N As Byte
Dim Blue As Byte
Dim Dtime As Byte
Dim Key As String * 1
Dim Kbchar As String * 10 , Tempstr As String * 11
Dim Col As Byte , Row As Byte
Dim Keyrel As Byte


Dim Ra As Single , Rb As Single , Cap As Single
Dim T1 As Single , T2 As Single , Freq As Single
Dim Duty As Single , Capt As Single

Declare Sub Getstring(kbchar As String * 10)
Declare Sub Kb_disp(key As String * 1)
Declare Sub Sub Zero()


Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = P0.4 , Db5 = P0.5 , Db6 = P0.6 , Db7 = P0.7
Config Lcdpin = Pin , E = P0.3 , Rs = P0.2

Start:
Cls
'clear the LCD display
Lcd "555 calc Mostek"
Waitms 500


P1 = 0
 ' yellow
P0 = 0
 ' red
P2 = 255
 ' green bott as out and in
P3 = 0
' blue
'all ports off

Lowerline
Cursor On Blink
Lcd "RA in k:"
Call Getstring(kbchar)
Key = Left(kbchar , 1)
If Key = "." Then
Tempstr = "0" + Kbchar
Kbchar = Tempstr
End If


Ra = Val(kbchar)
If Ra = 0 Then
Call Zero() : Goto Start
End If


Cls
Lcd "RB in k:"
Call Getstring(kbchar)
Key = Left(kbchar , 1)
If Key = "." Then
Tempstr = "0" + Kbchar
Kbchar = Tempstr
End If


Rb = Val(kbchar)
If Rb = 0 Then
Call Zero() : Goto Start
End If

Cls
Lcd "C in mfd:"
Call Getstring(kbchar)
Key = Left(kbchar , 1)
If Key = "." Then
Tempstr = "0" + Kbchar
Kbchar = Tempstr
End If


Cap = Val(kbchar)
If Cap = 0 Then
Call Zero() : Goto Start
End If

Cls
Lcd "Processing..."
Waitms 255
'-------------------------
'if Ra = 1.0 : Rb = 10.0 : Cap = 10.0
'then f=7hz

Ra = Ra * 1000
Rb = Rb * 1000
T1 = Ra + Rb
T1 = T1 * Cap
T1 = T1 / 1000000
T1 = T1 * 0.693
T2 = Rb * Cap
T2 = T2 / 1000000
T2 = T2 * 0.693
Capt = T1 + T2
Freq = 1 / Capt
Duty = T1 / Capt

T1 = T1 * 1000
T2 = T2 * 1000
Capt = Capt * 1000
Duty = Duty * 100


Cls
Lcd "RA ohms=" ; Ra
Lowerline
Lcd "RB ohms=" ; Rb
Call Getstring(kbchar)
' wait for # press on keypad

Cls
Lcd "cap=" ; Cap
Lowerline
Lcd "F hz=" ; Freq
Call Getstring(kbchar)
' wait for # press on keypad

Cls
Lcd "t1 ms=" ; T1
Lowerline
Lcd "t2 ms=" ; T2
Call Getstring(kbchar)
' wait for # press on keypad
Cls
Lcd "T ms=" ; Capt
Lowerline
Lcd "duty %=" ; Duty
Call Getstring(kbchar)
' wait for # press on keypad
Cls
Lcd "F hz=" ; Freq
Lowerline
Lcd "The end..press#"
Call Getstring(kbchar)
' wait for # press on keypad
Goto Start


Rem -------------functions below ---------------
Sub Getstring(kbchar As String * 10)
Kbchar = ""

Do
' green row run (0 led)

Key = ""
P2 = &B01111111

For Row = 1 To 4


If Row = 1 Then
P2 = &B01111110
End If
If Row = 2 Then
P2 = &B01111101
End If
If Row = 3 Then
P2 = &B01111011
End If
If Row = 4 Then
P2 = &B01110111
End If

 ' look for port-2 pin  to go off
Debounce P2.4 , 0 , Col1 , Sub
Debounce P2.5 , 0 , Col2 , Sub
Debounce P2.6 , 0 , Col3 , Sub

If Key <> "" Then
' wait for key release
' 6-3-06
Key_rel:
P2 = &B01110000
' all rows=0  look for any col=0
Keyrel = P2
Keyrel = Keyrel And &B01110000
 If Keyrel <> &B01110000 Then
 Goto Key_rel
 Else
 P2 = &B01111111
 Exit For
 End If
Exit For
End If

Next Row

If Key = "#" Then
P2 = &B01111111
Exit Sub
End If

Kbchar = Kbchar + Key

Loop

Col1:
If Row = 1 Then Key = "1"
If Row = 2 Then Key = "4"
If Row = 3 Then Key = "7"
If Row = 4 Then Key = "."
Call Kb_disp(key)
Return

Col2:
If Row = 1 Then Key = "2"
If Row = 2 Then Key = "5"
If Row = 3 Then Key = "8"
If Row = 4 Then Key = "0"
Call Kb_disp(key)
Return

Col3:
If Row = 1 Then Key = "3"
If Row = 2 Then Key = "6"
If Row = 3 Then Key = "9"
If Row = 4 Then Key = "#"
Call Kb_disp(key)
Return

End Sub


Sub Kb_disp(key)
Lcd Key
Waitms 255
End Sub


Sub Zero()
Cls
Lcd "zero not allowed"
Wait 1
End Sub


End
' end of program size=4137 bytes
