'-----------------------------------------------------------------------------------------
'name                     : smtp.bas
'copyright                : (c) 1995-2005, MCS Electronics
'purpose                  : smtp demo(sending email)
'micro                    : Mega88
'suited for demo          : no
'commercial addon needed  : yes
'-----------------------------------------------------------------------------------------

$regfile = "m88def.dat"                                     ' used processor
$crystal = 8000000                                          ' used crystal
$baud = 19200                                               ' baud rate

$hwstack = 64                                               ' default use 40 for the hardware stack
$swstack = 64                                               ' default use 40 for the SW stack
$framesize = 64                                             ' default use64 for the frame space


'W3100A constants
Const Sock_stream = $01                                     ' Tcp
Const Sock_dgram = $02                                      ' Udp
Const Sock_ipl_raw = $03                                    ' Ip Layer Raw Sock
Const Sock_macl_raw = $04                                   ' Mac Layer Raw Sock
Const Sel_control = 0                                       ' Confirm Socket Status
Const Sel_send = 1                                          ' Confirm Tx Free Buffer Size
Const Sel_recv = 2                                          ' Confirm Rx Data Size

'socket status
Const Sock_closed = $00                                     ' Status Of Connection Closed
Const Sock_arp = $01                                        ' Status Of Arp
Const Sock_listen = $02                                     ' Status Of Waiting For Tcp Connection Setup
Const Sock_synsent = $03                                    ' Status Of Setting Up Tcp Connection
Const Sock_synsent_ack = $04                                ' Status Of Setting Up Tcp Connection
Const Sock_synrecv = $05                                    ' Status Of Setting Up Tcp Connection
Const Sock_established = $06                                ' Status Of Tcp Connection Established
Const Sock_close_wait = $07                                 ' Status Of Closing Tcp Connection
Const Sock_last_ack = $08                                   ' Status Of Closing Tcp Connection
Const Sock_fin_wait1 = $09                                  ' Status Of Closing Tcp Connection
Const Sock_fin_wait2 = $0a                                  ' Status Of Closing Tcp Connection
Const Sock_closing = $0b                                    ' Status Of Closing Tcp Connection
Const Sock_time_wait = $0c                                  ' Status Of Closing Tcp Connection
Const Sock_reset = $0d                                      ' Status Of Closing Tcp Connection
Const Sock_init = $0e                                       ' Status Of Socket Initialization
Const Sock_udp = $0f                                        ' Status Of Udp
Const Sock_raw = $10                                        ' Status of IP RAW

Const Debug = -1                                            ' for sending feeback to the terminal

Const Smtpuser = "HELO username{013}{010}"


#if Debug
   Print "Start of SMTP demo"
#endif

Enable Interrupts                                           ' enable interrupts
'specify  MAC, IP, submask and gateway
'local port value will be used when you do not specify a port value while creating a connection
'TX and RX are setup to use 4 connections each with a 2KB buffer
Config Tcpip = Int0 , Mac = 00.44.12.34.56.78 , Ip = 192.168.0.8 , Submask = 255.255.255.0 , Gateway = 192.168.0.1 , Localport = 1000 , Tx = $55 , Rx = $55 , Twi = &H80 , Clock = 400000

'dim the used variables
Dim S As String * 50 , I As Byte , J As Byte , Tempw As Word
#if Debug
  Print "setup of W3100A complete"
#endif

'First we need a socket
I = Getsocket(0 , Sock_stream , 5000 , 0)
'             ^ socket numer     ^ port
#if Debug
   Print "Socket : " ; I
  'the socket must return the asked socket number. It returns 255 if there was an error
#endif

If I = 0 Then                                               ' all ok
   'connect to smtp server
   J = Socketconnect(i , 123.123.123.123 , 25)              ' smtp server and SMTP port 25
   '                 ^socket
   '                      ^ ip address of the smtp server
   '                                          ^ port 25 for smtp
    '  DO NOT FORGET to ENTER a valid IP number of your ISP smtp server
   #if Debug
       Print "Connection : " ; J
       Print S_status(1)
   #endif
   If J = 0 Then                                            ' all ok
      #if Debug
         Print "Connected"
      #endif
      Do
         Tempw = Socketstat(i , 0)                          ' get status
         Select Case Tempw
           Case Sock_established                            ' connection established
               Tempw = Tcpread(i , S)                       ' read line
               #if Debug
                   Print S                                  ' show info from smtp server
               #endif
               If Left(s , 3) = "220" Then                  ' ok
                  Tempw = Tcpwrite(i , Smtpuser )           ' send username
                  #if Debug
                    Print Tempw ; "  bytes written"         ' number of bytes actual send
                  #endif
                  Tempw = Tcpread(i , S)                    ' get response
                  #if Debug
                     Print S                                ' show response
                  #endif
                  If Left(s , 3) = "250" Then               ' ok
                     Tempw = Tcpwrite(i , "MAIL FROM:<tcpip@test.com>{013}{010}")       ' send from address
                     Tempw = Tcpread(i , S)                 ' get response
                     #if Debug
                        Print S
                     #endif
                     If Left(s , 3) = "250" Then            ' ok
                        Tempw = Tcpwrite(i , "RCPT TO:<tcpip@test.com>{013}{010}")       ' send TO address
                        Tempw = Tcpread(i , S)              ' get response
                        #if Debug
                           Print S
                        #endif
                        If Left(s , 3) = "250" Then         ' ok
                           Tempw = Tcpwrite(i , "DATA{013}{010}")       ' speicfy that we are going to send data
                           Tempw = Tcpread(i , S)           ' get response
                           #if Debug
                              Print S
                           #endif
                           If Left(s , 3) = "354" Then      ' ok
                              Tempw = Tcpwrite(i , "From: tcpip@test.com{013}{010}")
                              Tempw = Tcpwrite(i , "To: tcpip@test.com{013}{010}")
                              Tempw = Tcpwrite(i , "Subject: BASCOM SMTP test{013}{010}")
                              Tempw = Tcpwrite(i , "X-Mailer: BASCOM SMTP{013}{010}")
                              Tempw = Tcpwrite(i , "{013}{010}")
                              Tempw = Tcpwrite(i , "This is a test email from BASCOM SMTP{013}{010}")
                              Tempw = Tcpwrite(i , "Add more lines as needed{013}{010}")
                              Tempw = Tcpwrite(i , ".{013}{010}")       ' end with a single dot

                              Tempw = Tcpread(i , S)        ' get response
                              #if Debug
                                  Print S
                              #endif
                              If Left(s , 3) = "250" Then   ' ok
                                 Tempw = Tcpwrite(i , "QUIT{013}{010}")       ' quit connection
                                 Tempw = Tcpread(i , S)
                                 #if Debug
                                    Print S
                                 #endif
                              End If
                           End If
                        End If
                     End If
                  End If
               End If
           Case Sock_close_wait
              Print "CLOSE_WAIT"
              Closesocket I                                 ' close the connection
           Case Sock_closed
              Print "Socket CLOSED"                         ' socket is closed
              End
         End Select
      Loop
   End If
End If
End                                                         'end program