'-----------------------------------------------------------------------------------------
'name                     : sntp.bas   RFC 2030
'copyright                : (c) 1995-2005, MCS Electronics
'purpose                  : test SNTP() function
'micro                    : Mega88
'suited for demo          : yes
'commercial addon needed  : no
'-----------------------------------------------------------------------------------------
$lib "datetime.lbx"                                         'this example uses date time routines


$regfile = "m88def.dat"                                     ' specify the used micro

$crystal = 8000000                                          ' used crystal frequency
$baud = 19200                                               ' use baud rate
$hwstack = 80                                               ' default use 32 for the hardware stack
$swstack = 128                                              ' default use 10 for the SW stack
$framesize = 80                                             ' default use 40 for the frame space


Const Sock_stream = $01                                     ' Tcp
Const Sock_dgram = $02                                      ' Udp
Const Sock_ipl_raw = $03                                    ' Ip Layer Raw Sock
Const Sock_macl_raw = $04                                   ' Mac Layer Raw Sock
Const Sel_control = 0                                       ' Confirm Socket Status
Const Sel_send = 1                                          ' Confirm Tx Free Buffer Size
Const Sel_recv = 2                                          ' Confirm Rx Data Size

'socket status
Const Sock_closed = $00                                     ' Status Of Connection Closed
Const Sock_arp = $01                                        ' Status Of Arp
Const Sock_listen = $02                                     ' Status Of Waiting For Tcp Connection Setup
Const Sock_synsent = $03                                    ' Status Of Setting Up Tcp Connection
Const Sock_synsent_ack = $04                                ' Status Of Setting Up Tcp Connection
Const Sock_synrecv = $05                                    ' Status Of Setting Up Tcp Connection
Const Sock_established = $06                                ' Status Of Tcp Connection Established
Const Sock_close_wait = $07                                 ' Status Of Closing Tcp Connection
Const Sock_last_ack = $08                                   ' Status Of Closing Tcp Connection
Const Sock_fin_wait1 = $09                                  ' Status Of Closing Tcp Connection
Const Sock_fin_wait2 = $0a                                  ' Status Of Closing Tcp Connection
Const Sock_closing = $0b                                    ' Status Of Closing Tcp Connection
Const Sock_time_wait = $0c                                  ' Status Of Closing Tcp Connection
Const Sock_reset = $0d                                      ' Status Of Closing Tcp Connection
Const Sock_init = $0e                                       ' Status Of Socket Initialization
Const Sock_udp = $0f                                        ' Status Of Udp
Const Sock_raw = $10                                        ' Status of IP RAW



Print "Init TCP"                                            ' display a message
Enable Interrupts                                           ' before we use config tcpip , we need to enable the interrupts
Config Tcpip = Int0 , Mac = 12.128.12.34.56.78 , Ip = 192.168.0.8 , Submask = 255.255.255.0 , Gateway = 192.168.0.1 , Localport = 1000 , Tx = $55 , Rx = $55 , Twi = &H80 , Clock = 400000
Print "Init done"

Dim Var As Byte                                             'for i2c test


Dim Ip As Long                                              ' IP number of time server
Dim Idx As Byte                                             ' socket number
Dim Lsntp As Long                                           'long SNTP time
'--------------------------------------------------------------------------------------------
'When you use UDP, you need to dimension the following variables in exactly the same order !
Dim Peersize As Integer , Peeraddress As Long , Peerport As Word
'--------------------------------------------------------------------------------------------

Print "SNTP demo"

'assign the IP number of a SNTP server
Ip = Maketcp(192.43.244.18 )                                'assign IP num  NIST time.nist.gov  port 37
Print "Connecting to : " ; Ip2str(ip)


'we will use Dutch format
Config Date = Dmy , Separator = -


'we need to get a socket first
'note that for UDP we specify sock_dgram
Idx = Getsocket(idx , Sock_dgram , 5000 , 0)                ' get socket for UDP mode, specify port 5000
Print "Socket " ; Idx ; " " ; Idx

'UDP is a connection less protocol which means that you can not listen, connect or can get the status
'You can just use send and receive the same way as for TCP/IP.
'But since there is no connection protocol, you need to specify the destination IP address and port
'So compare to TCP/IP you send exactly the same, but with the addition of the IP and PORT
'The SNTP uses port 37 which is fixed in the tcp asm code



Do

   'toggle the variable
   Toggle Var

   Waitms 1000

   Lsntp = Sntp(idx , Ip)                                   ' get time from SNTP server
 '  Print Idx ; Lsntp
   'notice that it is not recommended to get the time every sec
   'the time server might ban your IP
   'it is better to sync once or to run your own SNTP server and update that once a day

   'what happens is that IP number of timer server is send a diagram too
   'it will put the time into a variable lsntp and this is converted to BASCOM date/time format
   'in case of a problem the variable is 0
   Print Date(lsntp) ; Spc(3) ; Time(lsntp)
Loop


End





