'--------------------------------------------------------------
'                        EDBexperiment19.bas
'       Experiment 19 voor het Educatief Ontwikkel Bord
'                  (c) 1995-2005, MCS Electronics
'                        Bestandsversie 1.0
'--------------------------------------------------------------
'
'Doel:
'Dit programma laat zien hoe we de temperatuur kunnen lezen
'van een IC chip. Het programma geeft de temperatuur weer in
'de UART

'In het data sheet van de DS1624 kunt u meer vinden over de
'address- en commandbytes die kunnen worden gebruikt. In dit
'voorbeeldprogramma zijn al deze gegevens al verwerkt.
'
'Conclusies:
'U zou nu met IC moeten kunnen werken


$regfile = "m88def.dat"                                     'Geef aan welke chip we gebruiken
$crystal = 8000000                                          'Geef de snelheid van de interne oscillator aan
$baud = 19200                                               'Geef de UART baudrate aan


'Dimensioneer RAM voor opslag van de temperatuur
Dim I2ctemp As Byte                                         'Opslag voor de temperatuur


'Configureer de pinnen die we willen gebruiken voor de IC bus
Config Scl = Portd.1                                        'Is de serieele klok SCL
Config Sda = Portd.3                                        'Is de serieele data SDA


'Declareer constanten - I2C chip adressen
Const Ds1624wr = &B10010000                                 'DS1624 Temperatuur sensor write
Const Ds1624rd = &B10010001                                 'DS1624 Temperatuur sensor read

'Vanaf hier initialiseren we de DS1624
   I2cstart                                                 'Dit genereerd de start conditie
   I2cwbyte Ds1624wr                                        'Dit stuurt het address byte met read/write bit 0
   I2cwbyte &HAC                                            'Vraag toegang tot het CONFIG register (&HAC address byte)
   I2cwbyte &H00                                            'Stel in op continu conversie  (&H00 command byte)
   I2cstop                                                  'Dit genereerd de stop conditie
   Waitms 25                                                'We moeten een ogenblik wachten na een stop conditie

   I2cstart
   I2cwbyte Ds1624wr
   I2cwbyte &HEE                                            'Start de conversie (&HEE command byte)
   I2cstop
   Waitms 25
'End of initialization

Print                                                       'Print een lege regel



Do

   'Dit haalt de huidige temperature op
   I2cstart
   I2cwbyte Ds1624wr
   I2cwbyte &HAA                                            'Read temperatuur (&HAA command byte)
   I2cstart
   I2cwbyte Ds1624rd                                        'Nu zal de chip de inhoud van de registers geven
   I2crbyte I2ctemp                                         'Temperatuur is opgeslagen a;s 12,5 maar ,5 eerst
   I2crbyte I2ctemp , Nack                                  'Dus we moeten 2x lezen... eerst de  ,5
   I2cstop                                                  'En dan de 12... we slaan de ,5 niet op
                                                                'Dat is de reden waarom we 2x lezen.

                                                                'We moeten NACK genereren na het laatst gelezen byte(protcol)

   'Uiteindelijk kunnen we de temperatuur weergeven

   Print "Het is nu: " ; Str(i2ctemp) ; " graden" ; Chr(13);

   Waitms 25

Loop
End

'(
U kan meerdere Ds1624 op een Ic Bus aansluiten.

U kunt het adres van de Ds1624 Slaves instellen door Vcc of Gnd 
aan te sluiten op Pin 5 , 6 en 7. Het adres van de Ds1624 Is 1001 +
de logische waarden van pin 7 , 6 en 5( + het Read / Write Bit).
')