'----------------------------------------------------------------
'                          (c) 1995-2005, MCS
'                        Bootloader.bas
'  This sample demonstrates how you can write your own bootloader
'  in BASCOM BASIC
'-----------------------------------------------------------------
'This sample will be extended to support other chips with bootloader
'The loader is supported from the IDE

$regfile = "m88def.dat"
$loader = $c00                                              'this address you can find in the datasheet
'the loader address is the same as the boot vector address

$crystal = 8000000
$baud = 57600                                               'this loader uses serial com
'It is VERY IMPORTANT that the baud rate matches the one of the boot loader
Config Com1 = Dummy , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0

'do not try to use buffered com as we can not use interrupts

'Dim the used variables
Dim Bstatus As Byte , Bretries As Byte , Bblock As Byte , Bblocklocal As Byte
Dim Bcsum1 As Byte , Bcsum2 As Byte , Buf(128) As Byte , Csum As Byte
Dim J As Byte , Spmcrval As Byte                            ' self program command byte value

Dim Z As Word                                               'this is the Z pointer word
Dim Vl As Byte , Vh As Byte                                 ' these bytes are used for the data values
Dim Wrd As Byte , Page As Byte                              'these vars contain the page and word address
'Mega 88 : 32 words, 128 pages


Disable Interrupts                                          'we do not use ints


Waitms 1000                                                 'wait 1 sec
'We start with receiving a file. The PC must send this binary file

'some constants used in serial com
Const Nak = &H15
Const Ack = &H06
Const Can = &H18

'we use some leds as indication in this sample , you might want to remove it
Config Portb = Output
Portb = 255                                                 'the stk200 has inverted logic for the leds

$timeout = 1000000                                          'we use a timeout

Bstatus = Waitkey()                                         'wait for the loader to send a byte
If Bstatus = 123 Then                                       'did we received value 123 ?
   Print Chr(123);                                          ' yes so confirm
   Goto Loader                                              'and start with the Xmodem-checksum reception
End If

For J = 1 To 10                                             'this is a simple indication that we start the normal reset vector
   Toggle Portb : Waitms 100
Next

Goto _reset                                                 'goto the normal reset vector at address 0


'this is the loader routine. It is a Xmodem-checksum reception routine
Loader:
Spmcrval = 3 : Gosub Do_spm                                 ' erase  the first page
Spmcrval = 17 : Gosub Do_spm                                ' re-enable page


Bretries = 10                                               'number of retries
Do
  Csum = 0                                                  'checksum is 0 when we start
  Print Chr(nak);                                           ' firt time send a nack
  Do
    Bstatus = Waitkey()                                     'wait for statuse byte
    Select Case Bstatus
       Case 1:                                              ' start of heading, PC is ready to send
            Incr Bblocklocal                                'increase local block count
            Csum = 1                                        'checksum is 1
            Bblock = Waitkey() : Csum = Csum + Bblock       'get block
            Bcsum1 = Waitkey() : Csum = Csum + Bcsum1       'get checksum first byte
            For J = 1 To 128                                'get 128 bytes
              Buf(j) = Waitkey() : Csum = Csum + Buf(j)
            Next
            Bcsum2 = Waitkey()                              'get second checksum byte
            If Bblocklocal = Bblock Then                    'are the blocks the same?
               If Bcsum2 = Csum Then                        'is the checksum the same?
                  Gosub Writepage                           'yes go write the page
                  Print Chr(ack);                           'acknowledge
               Else                                         'no match so send nak
                  Print Chr(nak);
               End If
            Else
               Print Chr(nak);                              'blocks do not match
            End If
       Case 4:                                              ' end of transmission , file is transmitted
             Print Chr(ack);                                ' send ack and ready

             Portb.3 = 0                                    ' simple indication that we are finished and ok
             Goto _reset                                    ' start new program
       Case &H18:                                           ' PC aborts transmission
             Goto _reset                                    ' ready

       Case Else
          Exit Do                                           ' no valid data
    End Select
  Loop
  If Bretries > 0 Then                                      'attempte left?
     Waitms 1000
     Decr Bretries                                          'decrease attempts
  Else
     Goto _reset                                            'reset chip
  End If
Loop



'write one or more pages
Writepage:
   For J = 1 To 128 Step 2                                  'we write 2 bytes into a page
      Vl = Buf(j) : Vh = Buf(j + 1)                         'get Low and High bytes
      lds r0, {vl}                                          'store them into r0 and r1 registers
      lds r1, {vh}
      Spmcrval = 1 : Gosub Do_spm                           'write value into page at word address
      Wrd = Wrd + 2                                         ' word address increases with 2 because LS bit of Z is not used
      If Wrd = 64 Then                                      ' page is full
          Wrd = 0                                           'Z pointer needs wrd to be 0
          Spmcrval = 5 : Gosub Do_spm                       'write page
          Page = Page + 1                                   'next page
          Spmcrval = 3 : Gosub Do_spm                       ' erase  next page
          Spmcrval = 17 : Gosub Do_spm                      ' re-enable page
      End If
   Next
   Toggle Portb.2 : Waitms 10 : Toggle Portb.2              'indication that we write
Return


Do_spm:
  Bitwait Spmcsr.selfprgen , Reset                          ' check for previous SPM complete
  Bitwait Eecr.eepe , Reset                                 'wait for eeprom

  Z = Page                                                  'make equal to page
  Shift Z , Left , 6                                        'shift to proper place
  Z = Z + Wrd                                               'add word
  lds r30,{Z}
  lds r31,{Z+1}

  Spmcsr = Spmcrval                                         'assign register
  spm                                                       'this is an asm instruction
  nop
  nop
Return


'How you need to use this program:
'1- compile this program
'2- program into chip with sample elctronics programmer
'3- select MCS Bootloader from programmers
'4- compile a new program for example M88.bas
'5- press F4 and reset your micro
' the program will now be uploaded into the chip with Xmodem Checksum
' you can write your own loader. And we will release a command line loader in the future
