'---------------------------------------------------------------------------
' Description:
'
' SE-ESD
' Electronic Sign Board
' 8 x 10 LED Dot Matrix
'
'
'          1  O O O O O O O O O O
'          2  O O O O O O O O O O
'          3  O O O O O O O O O O
'          4  O O O O O O O O O O
'          5  O O O O O O O O O O
'          6  O O O O O O O O O O
'          7  O O O O O O O O O O
'          8  O O O O O O O O O O
'
'             1 2 3 4 5 6 7 8 9 10
'
'
' Down Load Data Format ( ASCII Text 300 Bps Serial Data)
'
' S00112233445566 ....EEFF4
' |||||                 |||
' |||||                 ||+-- (102) Screoll Speed
' |||||                 |+--- (101) 50 th Byte LSB
' |||||                 +-----(100) 50 th Byte MSB
' |||||
' |||||
' |||||
' |||||
' ||||+---------------------- (  5) 2 nd Byte LSB
' |||+----------------------- (  4) 2 nd Byte MSB
' ||+------------------------ (  3) 1 st Byte LSB
' |+------------------------- (  2) 1 st Byte MSB
' +-------------------------- (  1) Start Mark
'
' Programmed by Junghoon Kim
' Programmed on 25 JUN 2005
' Compiled by BASCOM 8051 Demo
'
' http://www.mcselec.com/download_8051.htm
'
' SAMPLE Electronics co.
' TEL: +82-2-701-8051
' FAX: +82-2-701-8058
' C-18 P1-fl. Main-bd. ET-Land
' 16-9 Hangangno-3ga Yongsan-gu
' Seoul 140-879 South KOREA
' Mail : sample@korea.com
' Web : HTTP://WWW.SAMPLE.CO.KR
'
'---------------------------------------------------------------------------
$crystal = 12000000                                           ' XTAL Frequency 12.000MHz
Baud = 300                                                    ' 300 BPS   ( No Flow Control )
Config Sda = P3.5                                             ' I2C Data
Config Scl = P3.7                                             ' I2C Clock
'---------------------------------------------------------------------------
Const Scrollconst = 200                                       ' Scroll Multiply Constant
Const Buffer_size = 50                                        ' Buffer Size
'---------------------------------------------------------------------------
Const Buffer_end_adrs = Buffer_size - 1
Const Pole_end_adrs = Buffer_end_adrs - 10
'---------------------------------------------------------------------------
Dim T(1) As Byte                                              ' Bug test
Dim Display_buffer(buffer_size) As Byte                       ' Buffer Memory
Dim Dimmer As Word
Dim Scroll As Word
Dim Pole As Byte
Dim Temp As Byte
Dim Ignum As Byte
Dim Base As Byte
Dim Index As Byte
Dim E2padrs As Byte                                           ' EEPROM Address
Dim E2pdata As Byte                                           ' EEPROM Data
'---------------------------------------------------------------------------
On Timer0 Timebase                                            ' Timer0 Interrupt
'---------------------------------------------------------------------------
Config Timer0 = Timer , Gate = Internal , Mode = 2            ' Timer0 Auto Reload Timer Mode
Load Timer0 , &HBA                                            ' Auto Reload Constant 200 uSec
Start Timer0                                                  ' Start Timer0
Enable Timer0                                                 ' Enable Timer0
Enable Interrupts                                             ' Enable All Interrupt
'---------------------------------------------------------------------------
Main:
'
Dimmer = 0
Pole = 0
'
Gosub Buffer_set
'
Do
 Base = Inkey()
 If Base = "S" Then
    Disable Timer0
    P1 = &HFF
    Gosub Download
    Enable Timer0
    Gosub Buffer_set
 End If
Loop
'
'---------------------------------------------------------------------------
Download:
'
E2padrs = 0
'
For Index = 0 To Buffer_end_adrs
'
  Temp = Waitkey()
  If Temp > "9" Then
     Temp = Temp - 7
  End If
'
  Shift Temp , Left , 4
'
  E2pdata = Temp And &HF0
'
  Temp = Waitkey()
  If Temp > "9" Then
     Temp = Temp - 7
  End If
'
  Temp = Temp And &HF
  E2pdata = E2pdata Or Temp
'
  Gosub E2prom_write
  E2padrs = E2padrs + 1
'
Next Index
'
E2pdata = Waitkey()                                           ' Scroll Speed Data Write
Gosub E2prom_write
'
Return
'---------------------------------------------------------------------------
Buffer_set:
'
Disable Timer0                                                ' Disable Timer0
'
E2padrs = 0
Temp = 0
'
For Base = 0 To Buffer_end_adrs
'
  Gosub E2prom_read
  Display_buffer(temp) = E2pdata Xor &HFF
  E2padrs = E2padrs + 1
  Temp = Temp + 1
'
Next Base
'
Gosub E2prom_read
E2pdata = E2pdata And &H0F
Scroll = E2pdata * Scrollconst
'
If Scroll = 0 Then
  Scroll = 120
End If
'
Pole = 0
'
Enable Timer0                                                 ' Enable Timer0
'
Return
'---------------------------------------------------------------------------
E2prom_write:
'
' Input
'
' (Byte)E2padrs = EEPROM Address
' (Byte)E2pdata = Data
'
I2cstart                                                      ' Generate start
I2cwbyte &B10100000                                           ' Slave adsress
I2cwbyte E2padrs                                              ' Address of Control REG
I2cwbyte E2pdata                                              '
I2cstop                                                       ' Generate Stop
'
Waitms 10                                                     ' E2PROM Write delay Time
'
Return
'---------------------------------------------------------------------------
E2prom_read:
'
' Input
'
' (Byte)E2padrs = EEPROM Address
'
' Output
'
' (Byte)E2pdata
'
I2cstart                                                      ' Generate start
I2cwbyte &B10100000                                           ' Write slave adress
I2cwbyte E2padrs                                              ' Write adres of EEPROM to read
I2cstart                                                      ' Generate repeated start
I2cwbyte &B10100001                                           ' Write slave adress of EEPROM
I2crbyte E2pdata , Nack                                       ' Receive value into a. 9 means last byte to receive
I2cstop                                                       ' Generate stop
'
Return
'---------------------------------------------------------------------------
Timebase:                                                     ' Timer Interrupt 0
'
P1 = &HFF
'
Select Case Ignum
  Case 0 : P3 = &B11100001
  Case 1 : P3 = &B11100011
  Case 2 : P3 = &B11100101
  Case 3 : P3 = &B11100111
  Case 4 : P3 = &B11101001
  Case 5 : P3 = &B11101011
  Case 6 : P3 = &B11101101
  Case 7 : P3 = &B11101111
  Case 8 : P3 = &B11110001
  Case 9 : P3 = &B11110011
  Case Else
End Select
'
Temp = Ignum + Pole
If Temp > Buffer_end_adrs Then
   Temp = Temp - Buffer_size
End If
'
P1 = Display_buffer(temp)
'
Ignum = Ignum + 1
If Ignum > 9 Then
   Ignum = 0
End If
'
Incr Dimmer
'
If Dimmer > Scroll Then
   Dimmer = 0
   Incr Pole
'
   If Pole > Buffer_end_adrs Then
      Pole = 0
   End If
'
End If
'
Return
'---------------------------------------------------------------------------
'
'---------------------------- END OF FILE ----------------------------------