'------------------------------------------------------------------
'                    (c) 1997 Mirko Pelcl & Jure Mikeln
'                         Slovenija
'------------------------------------------------------------------
'           LED display
'           Multiplex on 2 displays
'           Demo project
'
'
'------------------------------------------------------------------
'Variable type declaration
Dim Clock As Byte , Clock1 As Byte , Mux As Byte , Seconds As Byte , X As Byte
Dim Var As Byte , Segments As Byte , Ones As Byte , Tenths As Byte
Dim Display As Bit , Calc As Bit

Config Timer0 = Timer , Gate = Internal , Mode = 2       'timer configuration

'Timer0             let's use timer 0
'Gate = Internal    no external interrupt
'Mode = 2           8 bit auto reload

On Timer0 Timer_0_int                     'interrupt routine


Load Timer0 , 250                         'loads value 250 sec into timer0
Priority Set Timer0
Enable Interrupts                         'Enable Interrupts
Enable Timer0                             'Enable timer0

Start Timer0                              'start timer0

Clock = 0                                 'set initial values for the variables
Clock1 = 0                                'set initial values for the variables
Seconds = 0                               'set initial values for the variables

Do                                        'start of an endless DO-LOOP loop
   If Calc = 1 Then                       'Calc= every second
      Calc = 0
'------------------------------------------------------------------
'Routine for Tenths and ones
      Tenths = Seconds / 10
      Var = Tenths * 10
      Ones = Seconds - Var

'------------------------------------------------------------------
   End If

   If Display = 1 Then                    'display only if Display=1
      Display = 0
      P1.0 = 1                            'set P1.0 to 1, open transistor
      P1.3 = 1
'------------------------------------------------------------------
'Routine for displaying tenths
      If Mux = 2 Then
         Var = Tenths
         'P1.0 = 1                      'it is not required to turn off the segment in this case
         Gosub Display                    'jump to Display subroutine
          P1.3 = 0
      End If
'------------------------------------------------------------------
'Routine for displaying ones
      If Mux = 0 Then
         Var = Ones
         'P1.3 = 1                      'it is not required to turn off the segment in this case
         Gosub Display                    'jump to Display subroutine
          P1.0 = 0
      End If
'------------------------------------------------------------------
   End If
Loop                                      'end of DO-LOOP loop
End                                       'end of program

'------------------------------------------------------------------
'interrupt routine
Timer_0_int:

    Incr Clock                            'increase Clock for 1
      If Clock > 19 Then                  'if Clock is more than 19
         Clock = 0                        'reset clock1 to 0
         Incr Mux                         'add 1 to Mux
         If Mux > 3 Then
             Mux = 0                      'reset to 0
         End If
         Display = 1                      'enable display

         Incr Clock1                      'increase Clock1 for 1
            If Clock1 > 199 Then          'if Clock1 is more than 199
                Clock1 = 0                'reset to 0
               P1.7 = Not P1.7            'control bit
               Calc = 1                   'set Calc to 1
               Incr Seconds
               If Seconds > 59 Then
                  Seconds = 0
               End If
            End If
         End If
Return
'------------------------------------------------------------------
'routine for displaying a value on a LED display

Display:                                  'avoid errors: colon must follow without a blank!
Restore Table                             'load the table into the memory
   For X = 0 To 9                         'from X = 0 to X = 9
      Read Segments                       'read a value from the table
                                        'move the value into the variable
                                        'named Segments
      If X = Var Then
         P3 = Segments                    'show Segments on port P3
         Exit For                         'end of FOR loop
      End If
   Next
Return

'---- data for correct display of numbers on LED display ------
Table:
Data &B01000001 , &B11011101 , &B01100100 , &B01001100 , &B11011000 , &B01001010 , &B01000010 , &B01011101 , &B01000000 , &B01001000

'Data can be binary notation. These data are for new version of BASCOM test board

'Data 3 , 159 , 38 , 14 , 154 , 74 , 66 , 31 , 2 , 10 ,'Data for old version of BASCOM test board