' Measuring frequencies from 15,26 Hz to 400 kHz

Dim Count As Word , Pom As Long , Decm As Byte
Dim F0 As Byte , F1 As Byte , Mj As Byte , Mj$$ As String * 5
Dim Disp$ As String * 4 , Disp$$ As String * 10

' LCD configuration: 16*1, 4-bit bus
Config Lcd = 16 * 1a
Config Lcdbus = 4
Cursor Off
Cls

' Timer and interrupt routines configuration
Config Timer1 = Counter , Gate = Internal , Mode = 2
On Timer0 Tim0 Nosave
On Timer1 Tim1 Nosave
 Priority Set Timer1
Enable Interrupts
Enable Timer0
Enable Timer1

' Main loop
Do
   Config Timer0 = Counter , Gate = Internal , Mode = 1
   Acc = 10                     ' coarse measurement of f
   Gosub Frek                   '    (T = 100 ms)
   If Count > 2999 Then        ' f > 30 kHz
      Decm = 5
   Elseif Count > 299 Then     ' f = 3 kHz - 30 kHz
      Acc = 100                 '    repeat measurement
      Gosub Frek                '    (T = 1 s)
      Decm = 4
   Elseif Count > 29 Then      ' f = 300 Hz-3 kHz
      Load Timer1 , 10          '    f : 10
      Gosub Time                '    measure T
      Decm = 3
   Else                         ' f < 300 Hz
      Load Timer1 , 1           '    f : 1
      Gosub Time                '    measure T
      Decm = 2
   End If
   Set P3.1
   If P3.1 = 1 Then             ' P3.1 = 1?
      Gosub Disp                '    display f/T
   End If
Loop

' Interrupt routine for Timer0
Tim0:
   Incr F0
Return

' Interrupt routine for Timer1
'    1st iteration: start Timer0
'    2nd iteration: reads Counter
Tim1:
   Count = Counter0
   Counter0 = 10
   Start Timer0
   Incr F1
Return

' Measuring of frequency
Frek:
   Counter0 = 0
   Start Timer0
   Gosub 10ms
   Count = Counter0
   Stop Timer0
Return

' 1 pulse duration measurement
'    and transformation into frequency
Time:
   Config Timer0 = Timer , Gate = Internal , Mode = 1
   F0 = 0
   F1 = 0
   Counter0 = 0
   Start Timer0
   Start Timer1
   Do
      If F0 > 0 Then
         Count = 0
         Exit Do
      End If
   Loop Until F1 > 1
   Stop Timer0
   Stop Timer1
   Gosub T_f
Return

' Display
Disp:
   Set P3.0
   If P3.0 = 1 Then             ' f ?
      Mj = 0                    '    [Hz]
      Disp$$ = " f = "
   Else                         ' T ?
      Mj = 2                    '    [micros]
      Decm = 6 - Decm
      Disp$$ = " T = "
      Gosub F_t
   End If
   If Count > 9999 Then        ' round result
      Count = Count + 5       ' to 4 decimals
      Count = Count / 10
       Incr Decm
   End If
   If Decm > 3 Then             ' Decm > 3 ?
      Decm = Decm - 3
      Incr Mj                   ' [kHz]/[ms]
   End If
   If Count < 1000 Then        ' too small value -> 0
      Disp$$ = Disp$$ + "0,0  "
   Else                         ' form display
      Disp$ = Str(Count)
      Disp$$ = Disp$$ + Left(disp$ , Decm)
      Incr Decm
      Disp$$ = Disp$$ + "." + Mid(disp$ , Decm)
   End If
   Mj$$ = Lookupstr(mj , Mj$)   ' read unit of measurement
   Home U
   Lcd Disp$$ ; " " ; Mj$$      ' display result
Return

' Table of measuring units
Mj$:
   Data "[Hz] " , "[kHz]" , "[s] " , "[ms] "

' f -> T, T -> f
F_t:
T_f:
   If Count > 1526 Then
      Pom = 100000000 / Count
      Count = Pom
   Else
      Count = 0
   End If
Return

' Delay routine
'    (t = Acc * 10 milis)
10ms:
   mov  r1,#10
   mov  r0,#242
   djnz r0,*-0
   djnz r0,*-0
   djnz r1,*-6
   dec  a
   nop
   nop
   jnz  *+3
   ret
   nop
   nop
   sjmp *-18
