'-------------------------------------------------------------------------------
'                               POP3.BAS
'                        (c) 2002 MCS Electronics
' sample that show how to read an email with POP3 protocol
'-------------------------------------------------------------------------------

$regfile = "m161def.dat"
$crystal = 4000000
$baud = 19200
$lib "tcpip.lbx"

Const Sock_stream = $01                                     ' Tcp
Const Sock_dgram = $02                                      ' Udp
Const Sock_ipl_raw = $03                                    ' Ip Layer Raw Sock
Const Sock_macl_raw = $04                                   ' Mac Layer Raw Sock
Const Sel_control = 0                                       ' Confirm Socket Status
Const Sel_send = 1                                          ' Confirm Tx Free Buffer Size
Const Sel_recv = 2                                          ' Confirm Rx Data Size

'socket status
Const Sock_closed = $00                                     ' Status Of Connection Closed
Const Sock_arp = $01                                        ' Status Of Arp
Const Sock_listen = $02                                     ' Status Of Waiting For Tcp Connection Setup
Const Sock_synsent = $03                                    ' Status Of Setting Up Tcp Connection
Const Sock_synsent_ack = $04                                ' Status Of Setting Up Tcp Connection
Const Sock_synrecv = $05                                    ' Status Of Setting Up Tcp Connection
Const Sock_established = $06                                ' Status Of Tcp Connection Established
Const Sock_close_wait = $07                                 ' Status Of Closing Tcp Connection
Const Sock_last_ack = $08                                   ' Status Of Closing Tcp Connection
Const Sock_fin_wait1 = $09                                  ' Status Of Closing Tcp Connection
Const Sock_fin_wait2 = $0a                                  ' Status Of Closing Tcp Connection
Const Sock_closing = $0b                                    ' Status Of Closing Tcp Connection
Const Sock_time_wait = $0c                                  ' Status Of Closing Tcp Connection
Const Sock_reset = $0d                                      ' Status Of Closing Tcp Connection
Const Sock_init = $0e                                       ' Status Of Socket Initialization
Const Sock_udp = $0f                                        ' Status Of Udp
Const Sock_raw = $10                                        ' Status of IP RAW

Const Debug = 1


#if Debug
    Print "Init system"
#endif

Config Lcd = 16 * 2                                         ' lcd we use
Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , E = Portb.4 , Rs = Portb.5
Cls                                                         ' clear LCD

Enable Interrupts
Config Tcpip = Int0 , Mac = 00.43.12.34.56.78 , Ip = 192.168.0.8 , Submask = 255.255.255.0 , Gateway = 192.168.0.1 , Localport = 1000 , Tx = $55 , Rx = $55

'dim variables
Dim S As String * 50 , I As Byte , J As Byte , Tempw As Word , P As Byte , Ilp As Word , Imsg As Word
#if Debug
    Print "Ready"
#endif

'get a socket
I = Getsocket(0 , Sock_stream , 5000 , 0)
#if Debug
    Print "socket : " ; I
#endif

If I <> 255 Then                                            ' all ok
   'connect to pop3 server
   J = Socketconnect(i , 64.0.0.0 , 110)       ' smtp server and POP3 port 110
   '   FILL IN IP number  ^^^^^
   #if Debug
       Print "Connection : " ; J
       Print S_status(1)
   #endif
   If J = 0 Then                                            ' all ok
      #if Debug
          Print "Connected"
      #endif
      Do
         Tempw = Socketstat(i , 0)                          ' get status
         Select Case Tempw
           Case Sock_established
               Tempw = Tcpread(i , S)                       ' get line
               #if Debug
                   Print S
               #endif
               If Left(s , 3) = "+OK" Then                  ' ok
                  Tempw = Tcpwrite(i , "USER username{013}{010}" )       ' send username
                  '                          ^^^ fill in user name 
                  Tempw = Tcpread(i , S)                    ' get response
                  #if Debug
                      Print S
                  #endif
                  If Left(s , 3) = "+OK" Then               ' ok
                     Tempw = Tcpwrite(i , "PASS aZDaa{013}{010}")       ' send password
                     '                           ^^^^^ fill in password
                     Tempw = Tcpread(i , S)                 ' get response
                     #if Debug
                         Print S
                     #endif
                     If Left(s , 3) = "+OK" Then            ' ok
                        Do
                            Tempw = Socketstat(i , 2)       ' get number of received bytes
                            If Tempw > 0 Then
                                Tempw = Tcpread(i , S)      ' get response
                                #if Debug
                                    Print S
                                #endif
                            Else
                              Exit Do                       ' no more data
                            End If
                        Loop
                        Tempw = Tcpwrite(i , "STAT{013}{010}")       'get stats
                        Tempw = Tcpread(i , S)
                        #if Debug
                            Print S
                        #endif
                        If Left(s , 3) = "+OK" Then         ' ok
                           '+OK 10 1204
                           S = Mid(s , 5)                   ' stop +ok
                           P = Instr(s , " ")
                           P = P - 1                        ' find space
                           S = Left(s , P)
                           Cls                              ' clear LCD
                           Lcd "Emails : " ; S
                           Imsg = Val(s)                    ' number of messages
                           For Ilp = 1 To Imsg
                             S = "TOP " + Str(ilp) + " 0{013}{010}"
                             J = Len(s)
                             Tempw = Tcpwrite(i , S , J)    ' ask for top lines(0) which will respond with only the header
                             Do
                                Tempw = Tcpread(i , S)
                                If Left(s , 8) = "Subject:" Then       ' check for subject
                                   S = Mid(s , 10)
                                   Home Lower : Lcd S       ' show header
                                   #if Debug
                                      Print S
                                   #endif
                                End If
                             Loop Until S = "."             ' end of data
                             Waitms 1000                    'some time to read the display
                           Next
                           Tempw = Tcpwrite(i , "QUIT{013}{010}")       ' quit
                           Tempw = Tcpread(i , S)
                        End If
                     End If
                  End If
               End If
           Case Sock_close_wait
              #if Debug
                 Print "CLOSE_WAIT"
              #endif
              Closesocket I                                 ' close connection
           Case Sock_closed
              #if Debug
                 Print "CLOSED"                             ' we are done
              #endif
              End
         End Select
      Loop
   End If
End If
End                                                         'end program