'-------------------------------------------------------------------------------
'                                 DHCP2.BAS
'                        (c)  by Atilio Mosca
'
'-------------------------------------------------------------------------------

$regfile = "m161def.dat"
$crystal = 4000000
$baud = 19200
$lib "tcpip.lbx"                                            ' specify the tcpip library

Const Dhcp_pack_request = $01
Const Dhcp_pack_reply = $02

Const Dhcp_htype10mb = $01
Const Dhcp_htype100mb = $02
Const Dhcp_hlenethernet = $06
Const Dhcp_hops = $00
Const Dhcp_secs = $00
Const Dhcp_flags = $80

Const Dhcp_discover = $01
Const Dhcp_offer = $02
Const Dhcp_request = $03
Const Dhcp_decline = $04
Const Dhcp_ack = $05
Const Dhcp_nak = $06
Const Dhcp_release = $07
Const Dhcp_inform = $08

Const Ip_source = $808e
Const Ip_gateway = $8080
Const Ip_mask = $8084

Const Padoption = 0
Const Subnetmask = 1
Const Timeroffset = 2
Const Router = 3
Const Timeserver = 4
Const Nameserver = 5
Const Dns = 6
Const Logserver = 7
Const Cookieserver = 8
Const Lprserver = 9
Const Impressserver = 10
Const Resourcelocationserver = 11
Const Hostname = 12
Const Bootfilesize = 13
Const Meritdumpfile = 14
Const Domainname = 15
Const Swapserver = 16
Const Rootpath = 17
Const Extentionspath = 18
Const Ipforwarding = 19
Const Nonlocalsourcerouting = 20
Const Policyfilter = 21
Const Maxdgramreasmsize = 22
Const Defaultipttl = 23
Const Pathmtuagingtimeout = 24
Const Pathmtuplateautable = 25
Const Ifmtu = 26
Const Allsubnetslocal = 27
Const Broadcastaddr = 28
Const Performmaskdiscovery = 29
Const Masksupplier = 30
Const Performrouterdiscovery = 31
Const Routersolicitationaddr = 32
Const Staticroute = 33
Const Trailerencapsulation = 34
Const Arpcachetimeout = 35
Const Ethernetencapsulation = 36
Const Tcpdefaultttl = 37
Const Tcpkeepaliveinterval = 38
Const Tcpkeepalivegarbage = 39
Const Nisdomainname = 40
Const Nisservers = 41
Const Ntpservers = 42
Const Vendorspecificinfo = 43
Const Netbiosnameserver = 44
Const Netbiosdgramdistserver = 45
Const Netbiosnodetype = 46
Const Netbiosscope = 47
Const Xfontserver = 48
Const Xdisplaymanager = 49
Const Dhcprequestedipaddr = 50
Const Dhcpipaddrleasetime = 51
Const Dhcpoptionoverload = 52
Const Dhcpmessagetype = 53
Const Dhcpserveridentifier = 54
Const Dhcpparamrequest = 55
Const Dhcpmsg = 56
Const Dhcpmaxmsgsize = 57
Const Dhcpt1value = 58
Const Dhcpt2value = 59
Const Dhcpclassidentifier = 60
Const Dhcpclientidentifier = 61
Const Myip = 254
Const Endoption = 255

Const Sock_stream = $01                                     ' Tcp
Const Sock_dgram = $02                                      ' Udp
Const Sock_ipl_raw = $03                                    ' Ip Layer Raw Sock
Const Sock_macl_raw = $04                                   ' Mac Layer Raw Sock
Const Sel_control = 0                                       ' Confirm Socket Status
Const Sel_send = 1                                          ' Confirm Tx Free Buffer Size
Const Sel_recv = 2                                          ' Confirm Rx Data Size

'socket status
Const Sock_closed = $00                                     ' Status Of Connection Closed
Const Sock_arp = $01                                        ' Status Of Arp
Const Sock_listen = $02                                     ' Status Of Waiting For Tcp Connection Setup
Const Sock_synsent = $03                                    ' Status Of Setting Up Tcp Connection
Const Sock_synsent_ack = $04                                ' Status Of Setting Up Tcp Connection
Const Sock_synrecv = $05                                    ' Status Of Setting Up Tcp Connection
Const Sock_established = $06                                ' Status Of Tcp Connection Established
Const Sock_close_wait = $07                                 ' Status Of Closing Tcp Connection
Const Sock_last_ack = $08                                   ' Status Of Closing Tcp Connection
Const Sock_fin_wait1 = $09                                  ' Status Of Closing Tcp Connection
Const Sock_fin_wait2 = $0a                                  ' Status Of Closing Tcp Connection
Const Sock_closing = $0b                                    ' Status Of Closing Tcp Connection
Const Sock_time_wait = $0c                                  ' Status Of Closing Tcp Connection
Const Sock_reset = $0d                                      ' Status Of Closing Tcp Connection
Const Sock_init = $0e                                       ' Status Of Socket Initialization
Const Sock_udp = $0f                                        ' Status Of Udp
Const Sock_raw = $10                                        ' Status of IP RAW

Declare Function Send_dhcp_discover() As Word
Declare Function Send_dhcp_request() As Word
Declare Function Socketstatus() As Word
Declare Function Xid_ok() As Byte
Declare Function Dhcp_offer_ok() As Byte
Declare Function Dhcp_ack_ok() As Byte
Declare Function Cookie_ok() As Byte
Declare Function Parse_dhcp_msg(byval Doption As Byte) As Byte
Declare Function Udp_mode_ok() As Byte
Declare Function Dhcp_ok() As Byte
Declare Sub Clearbuff()
Declare Sub Set_ip(byval Item As Word)
Declare Sub Sys_init()
Declare Sub Print_parse()
Declare Sub Copy4bytes(target As Byte)


'we will use the tt array only in the begin
Dim Tt(548) As Byte                                         'DHCP buffer

Dim Xid(4) As Byte
Dim Mac_add(6) As Byte
Dim Pa(4) As Byte
Dim Addptr1 As Byte
Dim Addptr2 As Byte
Dim Result As Word
Dim Peersize As Integer , Peeraddress As Long , Peerport As Word

Dim Ip(4) As Byte , Submask(4) As Byte , Gateway(4) As Byte

Print "-----------------"
Print "Reset"                                               ' display a message
Enable Interrupts                                           ' before we use config tcpip , we need to enable the interrupts
Config Tcpip = Int0 , Localport = 68 , Tx = $55 , Rx = $55 , Noinit = 1

'Transaction ID
'This number should be random
Xid(1) = 12
Xid(2) = 34
Xid(3) = 56
Xid(4) = 78

'Mac Address
'This number should match the one in the 'Config Tcpip...' line
'Do not use first byte
Mac_add(1) = 0
Mac_add(2) = 2
Mac_add(3) = 3
Mac_add(4) = 4
Mac_add(5) = 5
Mac_add(6) = 6

Wait 2                                                      'wait for W3100 linking
Print "Config OK"

'**************************** Main Program *************************************
Do
   Print "Connect..."
   If Udp_mode_ok() = 1 Then
     If Dhcp_ok() = 1 Then
       Print "DHCP OK"

'***********************************
'* Your program (with new IP) here...
'***********************************

       Stop
     Else
       Print "DHCP BAD"
     End If
   Else
     Print "Socket fail  "
   End If
   Waitms 2000
   Print "-----------------"
Loop

End

'********************************* RUTINAS *************************************
Function Udp_mode_ok() As Byte
Local Ax As Word
Local Temp_udp As Byte
Local Temp1 As Word

   Temp_udp = 0
   Print "Get socket"
   If Getsocket(0 , 2 , 68 , 128) = 0 Then
     Temp1 = Udpwrite(255.255.255.255 , 1000 , 0 , "test" ) 'if this line is not preset, it will never go to 'UDP mode'
     For Ax = 1 To 500
       Waitms 10
       If Socketstatus() = Sock_udp Then
         Temp_udp = 1
         Exit For
       End If
     Next Ax
   End If
   Udp_mode_ok = Temp_udp
   Waitms 100

End Function
'-------------------------------------------------------------------------------
Function Dhcp_ok() As Byte
Local Temp_ok As Byte
Local Xx As Byte

   Temp_ok = 0
   Print "--> Send DHCP Discover ";
   Result = Send_dhcp_discover()
   Print "(" ; Result ; " bytes)"
   For Xx = 1 To 100
     Waitms 10
     Result = Socketstat(0 , Sel_recv)
     If Result > 0 Then Exit For
   Next Xx
   If Result > 0 Then
     Print "<-- Receive DHCP Offer (" ; Result ; " bytes)"
     Clearbuff
     Result = Udpread(0 , Tt(1) , Result )
     If Tt(1) = Dhcp_pack_reply Then                        'DHCP reply
       If Xid_ok() = 1 Then                                 'same XactionID
         If Cookie_ok() = 1 Then                            'DHCP cookie?
           If Dhcp_offer_ok() = 1 Then                      'DHCP offer?
             Print "--> Send DHCP Request ";
             Result = Send_dhcp_request()
             Print "(" ; Result ; " bytes)"
             For Xx = 1 To 100
               Waitms 10
               Result = Socketstat(0 , Sel_recv)
               If Result > 0 Then Exit For
             Next Xx
             If Result > 0 Then
               Print "<-- Receive DHCP Pack (" ; Result ; " bytes)"
               Clearbuff
               Result = Udpread(0 , Tt(1) , Result )
               If Tt(1) = Dhcp_pack_reply Then              'DHCP reply?
                 If Xid_ok() = 1 Then                       'same XactionID?
                   If Cookie_ok() = 1 Then                  'DHCP cookie?
                     If Dhcp_ack_ok() = 1 Then              'DHCP ack ?
                       Pa(1) = Tt(17)                       'Get IP in buffer
                       Pa(2) = Tt(18)
                       Pa(3) = Tt(19)
                       Pa(4) = Tt(20)


                       Copy4bytes Ip(1)
                       Print "My IP:  ";
                       Print_parse
                       'Set_ip Ip_source
                       If Parse_dhcp_msg(subnetmask) = 1 Then
                         Print "Sub Net Mask:  ";
                         Print_parse
                         Copy4bytes Submask(1)
                         'Set_ip Ip_mask
                       End If
                       If Parse_dhcp_msg(router) = 1 Then
                         Print "Default Gateway:  ";
                         Print_parse
                         'Set_ip Ip_gateway
                         Copy4bytes Gateway(1)
                       End If
                       If Parse_dhcp_msg(dhcpserveridentifier) = 1 Then
                         Print "DHCP Server:  ";
                         Print_parse
                       End If
                       If Parse_dhcp_msg(dns) = 1 Then
                         Print "DNS Server:  ";
                         Print_parse
                       End If
                       Print "Reconfig..."

                       Settcp Mac_add(1) , Ip(1) , Submask(1) , Gateway(1)

                       'Sys_init
                       Temp_ok = 1
'*****************************************************************************
'*                         At this point, the W3100, responds to the new IP
'*                         provided by the DHCP server.
'*                         You can check this with PING
'*****************************************************************************
                     End If
                   End If
                 End If
               End If
             End If
           End If
         End If
       End If
     End If
   End If
   Dhcp_ok = Temp_ok

End Function
'-------------------------------------------------------------------------------
Function Dhcp_ack_ok() As Byte
   Dhcp_ack_ok = 0
   If Tt(241) = Dhcpmessagetype Then
     If Tt(242) = 1 Then
       If Tt(243) = Dhcp_ack Then
         Dhcp_ack_ok = 1
       End If
     End If
   End If
End Function
'-------------------------------------------------------------------------------
Function Dhcp_offer_ok() As Byte
   Dhcp_offer_ok = 0
   If Tt(241) = Dhcpmessagetype Then
     If Tt(242) = 1 Then
       If Tt(243) = Dhcp_offer Then
         Dhcp_offer_ok = 1
       End If
     End If
   End If
End Function
'-------------------------------------------------------------------------------
Function Xid_ok() As Byte
   Xid_ok = 0
   If Tt(5) = Xid(1) Then
     If Tt(6) = Xid(2) Then
       If Tt(7) = Xid(3) Then
         If Tt(8) = Xid(4) Then
           Xid_ok = 1
         End If
       End If
     End If
   End If
End Function
'-------------------------------------------------------------------------------
Function Cookie_ok() As Byte
   Cookie_ok = 0
   If Tt(237) = 99 Then
     If Tt(238) = 130 Then
       If Tt(239) = 83 Then
         If Tt(240) = 99 Then
           Cookie_ok = 1
         End If
       End If
     End If
   End If
End Function
'-------------------------------------------------------------------------------
Function Send_dhcp_discover() As Word
Local Xx As Word

   Clearbuff

   'DHCP
   Tt(1) = Dhcp_pack_request                                'Request
   Tt(2) = Dhcp_htype10mb                                   '10 mb ethernet
   Tt(3) = Dhcp_hlenethernet                                'mac address lenght
   Tt(4) = Dhcp_hops

   Tt(5) = Xid(1)
   Tt(6) = Xid(2)
   Tt(7) = Xid(3)
   Tt(8) = Xid(4)

   Tt(11) = Dhcp_flags                                      'flags

   Tt(29) = Mac_add(1)                                      'MAC address
   Tt(30) = Mac_add(2)
   Tt(31) = Mac_add(3)
   Tt(32) = Mac_add(4)
   Tt(33) = Mac_add(5)
   Tt(34) = Mac_add(6)

   Tt(237) = 99                                             'DHCP cookie
   Tt(238) = 130
   Tt(239) = 83
   Tt(240) = 99

   Tt(241) = Dhcpmessagetype                                'options
   Tt(242) = 1
   Tt(243) = Dhcp_discover

   Tt(244) = Dhcpparamrequest
   Tt(245) = 4                                              ' Request list
   Tt(246) = Subnetmask                                     'Subnet mask
   Tt(247) = Router                                         'Default Gateway
   Tt(248) = Dns                                            'DNS server
   Tt(249) = Endoption                                      'end options

   For Xx = 250 To 548                                      'refill
    Tt(xx) = 0
   Next Xx

   Send_dhcp_discover = Udpwrite(255.255.255.255 , 67 , 0 , Tt(1) , 548 )
End Function
'-------------------------------------------------------------------------------
Function Send_dhcp_request() As Word
Local Xx As Word

   'DHCP
   Tt(1) = Dhcp_pack_request                                'request

   Tt(13) = Tt(17)                                          'IP client
   Tt(14) = Tt(18)
   Tt(15) = Tt(19)
   Tt(16) = Tt(20)

   Tt(17) = 0                                               'my IP
   Tt(18) = 0
   Tt(19) = 0
   Tt(20) = 0

   Tt(241) = Dhcpmessagetype                                'options
   Tt(242) = 1
   Tt(243) = Dhcp_request

   Tt(244) = Dhcpparamrequest
   Tt(245) = 4
   Tt(246) = Subnetmask
   Tt(247) = Router
   Tt(248) = Dns
   Tt(249) = Endoption                                      'end options

   For Xx = 250 To 548                                      'refill
    Tt(xx) = 0
   Next Xx

   Send_dhcp_request = Udpwrite(255.255.255.255 , 67 , 0 , Tt(1) , 548 )
End Function

'-------------------------------------------------------------------------------
Function Parse_dhcp_msg(byval Doption As Byte) As Byte
Local Ax As Word
Local Ay As Byte
Local Az As Word

   Pa(1) = 0
   Pa(2) = 0
   Pa(3) = 0
   Pa(4) = 0
   Parse_dhcp_msg = 0
   Ax = 244
Pa_loop1:
   Ay = Tt(ax)
   If Ay = Endoption Then Goto Pa_end
   If Ay = Doption Then
     Ax = Ax + 2
     Pa(1) = Tt(ax)
     Incr Ax
     Pa(2) = Tt(ax)
     Incr Ax
     Pa(3) = Tt(ax)
     Incr Ax
     Pa(4) = Tt(ax)
     Parse_dhcp_msg = 1
     Goto Pa_end
   End If
   Incr Ax
   Ay = Tt(ax)
   Ax = Ax + Ay
   Incr Ax
   If Ax > 548 Then Goto Pa_end
   Goto Pa_loop1

Pa_end:
End Function
'-------------------------------------------------------------------------------
Sub Clearbuff()
Local Ax As Word

  For Ax = 1 To 548
    Tt(ax) = 0
  Next Ax
End Sub
'-------------------------------------------------------------------------------

Function Socketstatus() As Word
  Socketstatus = Socketstat(0 , Sel_control)
End Function
'-------------------------------------------------------------------------------


'-------------------------------------------------------------------------------
Sub Print_parse()
  Print Pa(1) ; " " ; Pa(2) ; " " ; Pa(3) ; " " ; Pa(4) ; " "
End Sub
'-------------------------------------------------------------------------------


Sub Copy4bytes(target As Byte)
 Dim I As Byte , J As Byte
  J = 5
  For I = 1 To 4
     J = J - 1
     Target(j) = Pa(i)
  Next
End Sub